/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.network;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import novamachina.exnihilosequentia.common.item.ore.Ore;
import novamachina.exnihilosequentia.common.network.HandshakeMessages;
import novamachina.exnihilosequentia.common.network.PacketHandler;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class ExNihiloHandshakeHandler {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());

    private ExNihiloHandshakeHandler() {
    }

    public static void handleAcknowledge(@Nonnull HandshakeMessages.C2SAcknowledge message, @Nonnull Supplier<NetworkEvent.Context> ctx) {
        logger.debug("Received acknowledgement from client. " + message);
        ctx.get().setPacketHandled(true);
    }

    public static void handleOreList(@Nonnull HandshakeMessages.S2COreList msg, @Nonnull Supplier<NetworkEvent.Context> ctx) throws InterruptedException {
        logger.debug("Recieved ore data from server");
        AtomicBoolean updatedOreList = new AtomicBoolean(false);
        CountDownLatch block = new CountDownLatch(1);
        ctx.get().enqueueWork(() -> {
            updatedOreList.set(true);
            if (!Ore.updateEnabledOres(msg)) {
                updatedOreList.set(false);
            }
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            logger.error(e.getMessage());
            throw e;
        }
        ctx.get().setPacketHandled(true);
        if (updatedOreList.get()) {
            logger.debug("Successfully synchronized ore list from server.");
            SimpleChannel handshakeChannel = PacketHandler.getHandshakeChannel();
            if (handshakeChannel != null) {
                handshakeChannel.reply((Object)new HandshakeMessages.C2SAcknowledge(), ctx.get());
            }
        } else {
            logger.debug("Failed to synchronize ore list from server.");
            ctx.get().getNetworkManager().m_129507_((Component)new TextComponent("Connection closed - [Ex Nihilo: Sequentia] Failed to synchronize ore list from server."));
        }
    }
}

